//  Copyright 1998 Macromedia, Inc. All rights reserved.

//form fields:
//Background - multiple list listing background colors
//Text - multiple list listing text colors. Contents change when new Background item picked.

//******************* GLOBALS **********************

var helpDoc = MM.HELP_cmdSetColorScheme;

//******************* API **********************

function commandButtons()
{
	return new Array(BTN_OK,    "applyColorScheme();window.close()",
                   BTN_Apply, "applyColorScheme()",
                   BTN_Cancel,"window.close()",
                   BTN_Help,  "displayHelp()")
}

function canAcceptCommand()
{
  return ((dreamweaver.getDocumentDOM() && dw.getDocumentDOM().getParseMode() == 'html') &&
 (((dw.getFocus() == 'document') 
    && (dreamweaver.getDocumentDOM("document").body)) ||
    (dw.getFocus(true) == 'html' || dw.getFocus() == 'textView')) );
}


//******************* LOCAL FUNCTIONS **********************
//function: initializeUI
//arguments: none
//return value: none
//description: called from body onload handler, fills the background list widget
//with colorSchemes[i], selects the first item, then fills the Text list with
//properties of colorSchemes[i]
function initializeUI()
{
	var Form = document.forms[0];
	var backgroundList = Form.Background; 
	var textList = Form.Text;
	//colorSchemes(),defined in colorSchemes.js, returns a multi-dimensional
	//array of of the form:
	// colorSchemes[backgroundColor][backgroundColorIndex][property]
	var Schemes = colorSchemes(); 
	                                       
	//populate Background list...
	var counter=0;
	for (i in Schemes){
	//properties added to the Array object as prototypes in other Dreamweaver files
	//appear as properties when executing for i in [object] loops. Following conditional check
	//ensures only array members of Schemes appear in Background list widget menu.
	  if (Schemes[i][0]) 
	  {
        backgroundList.options[counter] = new Option(BG_COLOR[i]);
        backgroundList.options[counter++].value = i;
	  }
	}

	backgroundList.selectedIndex=0; //select first item of Background list

	//populate Text list based on selected list item in Background list
	populateTextColorsList(backgroundList.options[backgroundList.selectedIndex].value);
}


//function: previewColorScheme
//arguments:backgroundColorIndex
//return value:none
//description: called when an item in the text list widget is clicked,
//previews the chosen color scheme on a table 1 cell high and 1 cell wide
function previewColorScheme(backgroundColorInd)
{
	var selInd = document.forms[0].Background.selectedIndex;
	var backgroundColor = document.forms[0].Background.options[selInd].text;
	var tableCellNode = findObject("text").parentNode.parentNode.parentNode;

	//format background color and text 
	with (colorSchemes()[backgroundColor][backgroundColorInd])
	{
		//change background color of table cell
		tableCellNode.setAttribute("bgcolor",bgcolor);
		//change colors of font nodes & update the text to reflect new color value
		changeFontNodePreviewColor('text',text); 
		changeFontNodePreviewColor('link',link);  
		changeFontNodePreviewColor('alink',alink);  
		changeFontNodePreviewColor('vlink',vlink);  
	}
}

//function:changeFontNodePreviewColor
//arguments: docPropName, e.g.: text,link,vlink
//           docPropValue,e.g.:'blue','#FFFF00'
//return value: none
//description: 1.updates the text representing the font property ('Text Color')
//to the correct color. 2.changes the text to reflect the new color value,
//e.g.: Text Color: #FFFF00
function changeFontNodePreviewColor(docPropName,docPropValue)
{
	var fontNode=findObject(docPropName).childNodes.item(0).childNodes.item(0)
	var fontNodeText = fontNode.innerHTML;
	var colonAt = fontNodeText.indexOf(":");
	var niceName = fontNodeText.substring(0,colonAt+1) + docPropValue;

	fontNode.setAttribute('color',docPropValue);
	fontNode.innerHTML = niceName;                                   
}

//function:applyColorScheme
//arguments:none
//return value:none
//purpose:applies the chosen color scheme to the user's document
function applyColorScheme()
{
	var currSelection = dreamweaver.getSelection();  //get current selection
	var textList = document.forms[0].Text;
	var backgroundList = document.forms[0].Background;
	var bodyTag = dreamweaver.getDocumentDOM("document").body;
	var selInd=backgroundList.selectedIndex;
	var backgroundColor = backgroundList.options[selInd].text;
	var textColors;
	selInd = textList.selectedIndex;
	textColors = textList.options[selInd].value

	with (colorSchemes()[backgroundColor][textColors])
	{
		bodyTag.setAttribute("bgcolor",bgcolor);
		bodyTag.setAttribute("text",text);
		bodyTag.setAttribute("link",link);
		bodyTag.setAttribute("alink",alink);
		bodyTag.setAttribute("vlink",vlink);
	}
	//reset current selection
	dreamweaver.setSelection(currSelection[0],currSelection[1]);  
}

//function: populateTextColorsList
//aguments: backgroundColor, e.g.: red
//return value: none
//description: called when a new item in the background list widget is picked,
//updates the Text and Links list to reflect text and link color choices
//available with the new background color
function populateTextColorsList(backgroundColor)
{
	var counter=0;
	var Schemes=colorSchemes();
	var textList = document.forms[0].Text;
	var currListLen = textList.options.length; //get # of items in current list

	//clear current list
	//for (i=0;i<currListLen;i++)
	//textList.options[0] = null;

	for (i in Schemes[backgroundColor])
	{ 	//populate text list
		//properties added to the Array object as prototypes in other Dreamweaver
		//files apppear as properties when executing for i in [object] loops.
		// Following conditional check ensures only array members of Schemes
		// appear in Text list widget menu.
		if (i==parseInt(i))
		{ //check that i is property of colorSchemes
			textList.options[counter] = new Option(Schemes[backgroundColor][i]['name']);
			textList.options[counter++].value = i;
    	}
	}
	//kill any leftover previous names
	for (i=currListLen-1;i>counter-1;i--){
		textList.options[i] = null
	}

	textList.selectedIndex=0; //select first item of Text list

	//format preview area according to selected item in Text list
	previewColorScheme(textList.options[textList.selectedIndex].value);
}

//******************* GENERIC FUNCTIONS **********************

function findObject(objName,  parentObj) {
  var i,tempObj="",found=false,curObj = "";
  var NS = (navigator.appName.indexOf("Netscape") != -1);
  if (!NS && document.all) curObj = document.all[objName]; //IE4
  else {
    parentObj = (parentObj != null)? parentObj.document : document;
    if (parentObj[objName] != null) curObj = parentObj[objName]; //at top level
    else { //if in form
      if (parentObj.forms) for (i=0; i<parentObj.forms.length; i++) {  //search level for form object
        if (parentObj.forms[i][objName]) {
          curObj = parentObj.forms[i][objName];
          found = true; break;
      } }
      if (!found && NS && parentObj.layers && parentObj.layers.length > 0) {
        parentObj = parentObj.layers;
        for (i=0; i<parentObj.length; i++) { //else search for child layers
          tempObj = findObject(objName,parentObj[i]); //recurse
          if (tempObj) { curObj = tempObj; break;} //if found, done
  } } } }
  return curObj;
}
